import UIKit
import MetalKit
import simd
import PlaygroundSupport

let shaders = "#include <metal_stdlib>\nusing namespace metal;struct V{float4 p [[position center_no_perspective]];float2 c[[center_perspective]];};vertex V vf(constant float4 *pos [[buffer(0)]],constant float2 *tc [[buffer(1)]],uint vid [[vertex_id]]){V v;v.p = pos[vid];v.c = tc[vid];return v;}\n" +
	
    "fragment float4 ff (V v [[stage_in]]){\n" +
    "float2 c=v.c*2-1;" + 
"float3 p=float3(100),r=normalize(float3(c,-1));float t=0;int i=0;" + 
    "for(;i<1000;i++){" + 
    "float d=length(fmod(p,float3(1.0))-float3(0.5))-0.3;" + 
"d=max(length(p-float3(100,100,80))-19,d);" + 
    "if(d<0.01) break;" + 
"p+=(r+float3(sin(p.z*4),cos(p.z*4),0)*(d+1)*t*0.2)*d;t+=d;" + 
    //"p+=r+(float3(sin(p.y*4),cos(p.x*4),0)*3)*d;t+=d;" + 
    "}" + 
"float l=1/t;" + 
    "p=fmod(p,1);p*=2*abs(dot(p-0.5,r))/pow(t,0.05);p=mix(p,mix(float3(0.7,0.8,1),float3(1,0,0),t/8),1-min(1.0,float(i)/30));" +
"    return float4(p, 1.0);}"

class View: UIImageView {
    
    required init?(coder aDecoder: NSCoder) {super.init(coder: aDecoder)}
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        let d = MTLCreateSystemDefaultDevice()!
		
		// initialise queue + pipeb let dev =  {
        let q = d.newCommandQueue()
			let l = try! d.newLibrary(withSource: shaders, options: nil)
			let vs = l.newFunction(withName: "vf")
			let fs = l.newFunction(withName: "ff")
			let ps = MTLRenderPipelineDescriptor()
        ps.vertexFunction = vs
        ps.fragmentFunction = fs
        ps.colorAttachments[0].pixelFormat = .BGR10_XR
        let p = try! d.newRenderPipelineState(with: ps)
        
			let po: [float4] = [float4(-1.0, 1.0, 0.0, 1.0), float4(1.0, 1.0, 0.0, 1.0), float4(-1.0, -1.0, 0.0, 1.0), float4(1.0, -1.0, 0.0, 1.0)]
			let c = [float2(0.0, 1.0), float2(1.0, 1.0), float2(0.0, 0.0), float2(1.0, 0.0)]
        let pb = d.newBuffer(withBytes: po, length: sizeof(float4.self) * po.count, options: MTLResourceOptions())
        let tb = d.newBuffer(withBytes: c, length: sizeof(float2.self) * c.count, options: MTLResourceOptions())
        
        let cb = q.commandBuffer()
        let pd = MTLRenderPassDescriptor()
        let td = MTLTextureDescriptor.texture2DDescriptor(with: .BGR10_XR, width: 1920, height: 1080, mipmapped: false)
        let tex = d.newTexture(with: td)
        pd.colorAttachments[0].texture = tex
        pd.colorAttachments[0].loadAction = .dontCare
        pd.colorAttachments[0].storeAction = .store
        
        let e = cb.renderCommandEncoder(with: pd)
        e.setRenderPipelineState(p)
        
        e.setVertexBuffer(pb, offset: 0, at: 0)
        e.setVertexBuffer(tb, offset: 0, at: 1)
        
        e.drawPrimitives(.triangleStrip, vertexStart: 0, vertexCount: 4)
        
        e.endEncoding()
        cb.commit()
        
            self.image = UIImage(ciImage: CIImage(mtlTexture: tex, options: [kCIImageColorSpace: CGColorSpaceCreateDeviceRGB()])!)
        }
}

let v = View(frame: CGRect(x: 0.0, y: 0.0, width: 400.0, height: 400.0))

PlaygroundPage.current.liveView = v


